#!/usr/bin/perl
# lun ago  8 14:37:00 CEST 2005
# author: Pedro Larroy Tovar
#
# This script creates a PCM Wav file as the result of dumping the audio
# from the video streams on the database
#

use warnings;
use strict;
use File::Find;
use File::Copy;
use Getopt::Long;

#######
# TUNABLES: 
#
# External program for dumping audio stream to a file
#  
#my $PROG='mplayer -ao pcm:file=XXXSTREAMXXX -vo null';
#
# Extension of the video streams
#
my $EXT='avi';
#
#######

my %opt;

sub usage {
die<<EOT;
$0 usage:
	$0 [options] directory1 [directory2] ...

	options:
		--help		this screen
		--overwrite	overwrites the streams
		--verbose	shows mplayer output
		--fixheader option to fix the byte alignment field of the wav header
			in case unpatched mplayer is used (dirty! it only works for 16bit mono files)


EOT
}

sub disable_stdout_stderr {
	no warnings;
	open(OLDSTDOUT,">&STDOUT") or die "Open:$!";
	open(OLDSTDERR,">&STDOUT") or die "Open:$!";
	open(FNULL,'>/dev/null') or die "open: $!";	
	open(STDERR,">&FNULL") or die "open: $!";
	open(STDOUT,">&FNULL") or die "open: $!";

}

sub enable_stdout_stderr {
	no warnings;
	close(STDERR) or die "close: $!";
	close(STDOUT) or die "close: $!";
	close(FNULL) or die "close: $!";
	open(STDERR,">&OLDSTDERR") or die "open: $!";
	open(STDOUT,">&OLDSTDOUT") or die "open: $!";
}

sub found {
	if ( -f $_ && m/(.*)\.\Q$EXT\E$/ ) {
		my $dumpfile = $1.'.wav';
		if ( -r $_ ) {
			if ( ! -f $dumpfile || $opt{overwrite} ) {
				#my @CMD = ('mplayer','-really-quiet','-ao','pcm:file='.$dumpfile,'-vo','null',$_);			
				my @CMD = ('mplayer','-af','resample=16000:0:2,channels=1','-ao','pcm:file=__dump__.wav','-vc','dummy','-vo','null',$_);			
				print "Dumping $_ to $dumpfile... ";
				if ( ! $opt{verbose} ) {
					disable_stdout_stderr;
				}
				system(@CMD) == 0 or die join(' ',@CMD).": $!";
				#
				# Fix wav header bug, probably on mplayer
				#
				if( $opt{fixheader} ) {
					open(WAV,"+<__dump__.wav") or die "open: $!";
					seek(WAV,0x20,0) or die "seek: $!";
					print WAV pack("c",2);
					close(WAV) or die "close: $!";
				}
				#
				move("__dump__.wav",$dumpfile) or die "move: $!";
				if ( ! $opt{verbose} ) {
					enable_stdout_stderr;
				}
				print "done\n";
			} else {
				warn $dumpfile.": file exists, skipping (use --overwrite to force overwritting";
			}
		} else {
			warn $_.": not readable";
		}
	}
}

GetOptions(
	'help' => \$opt{help},
	'verbose' => \$opt{verbose},
	'overwrite' => \$opt{overwrite},
	'fixheader' => \$opt{fixheader},
) or usage;
usage if $opt{help};

if ( ! @ARGV ) {
	usage();
}
foreach my $arg (@ARGV) {
	if ( ! -d $arg ) {
		die "$arg: not a directory, see usage";
	}
}

find(\&found,@ARGV);




